# -*- coding: utf-8 -*-

# Importation des bibliothèques utiles
import numpy as np
import matplotlib.pyplot as plt

"""
Tracé du diagramme de Bode d'un filtre d'ordre 1

Fonction de transfert complexe H =  H0*Numérateur /(1+jf/fc)
        Passe-bas : Numérateur = 1
        Passe-haut : Numérateur = f/fc
"""

# Valeurs numériques des constantes du filtre
#---------------------------------------------------------------
fc = 140          # CHOISIR LA VALEUR DE fc en Hz, fréquence de coupure
H0 = 1            # choisir la valeur de H0
#---------------------------------------------------------------


k = 2000                                # nombre de points
f = np.logspace(-2, 2, k+1)*fc          # k intervalles, entre 10^-2fc et 10^2fc ; n+1 valeurs


#Définition de la fonction de transfert selon la nature du filtre choisi, décommenter'

def H(H0, fc, f):                 # ordre des variables arbitraire, à conserver à chaque appel de fonction
    #num = 1                     # passe-bas
    num = 1j*f/fc                # passe-haut
    return H0*num/(1 + 1j*f/fc)


#Définition du diagramme de Bode

GdB = 20*np.log10(np.abs(H(H0, fc, f)))
phi = np.angle(H(H0, fc, f), deg=True)


#Tracé de GdB et phi en concordance de fréquence
plt.subplot(211)
plt.semilogx(f, GdB)
plt.title('Diagramme de Bode ordre 1, H0=' + str(H0) + '  fc =' + str(fc)+ 'Hz')
#plt.title(f'Diagramme de Bode ordre 1, H0={H0}, fc = {fc} Hz')
plt.ylabel('GdB')
plt.grid()

plt.subplot(212)
plt.semilogx(f, phi)
plt.ylabel('phase (°)')
plt.xlabel('f (Hz)')
plt.grid()

plt.show()

